import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Form, TextArea, Checkbox} from 'react-form';
import MeteoSelect from "../Fields/MeteoSelect/MeteoSelect";
import LimpidezzaSelect from "../Fields/LimpidezzaSelect/LimpidezzaSelect";
import SpeciesChooser from "../Fields/SpeciesChooser/SpeciesChooser";
import Typeahead from "../Fields/Typeahead/Typeahead";
import Text from "../Fields/Text/Text";
import DateTime from "../Fields/DateTime/DateTime";
import TipologiaMonitoraggioSelect from "../Fields/TipologiaMonitoraggioSelect/TipologiaMonitoraggioSelect";
import {sitoNatura2000SmartFilterQuery,metadatiHabitatQuery} from "../../../api/queries";
import ReactTable from "react-table";
import Loading from "../../Loading/Loading";
import {graphql,withApollo} from "react-apollo";
import {findById} from "../../../utils";
import {withRouter} from "react-router-dom";
import MonitoraggioHabitatMetadati from './MonitoraggioHabitatMetadati/MonitoraggioHabitatMetadati'
import MonitoraggioHabitatDocumenti from "./MonitoraggioHabitatDomuneti";
import Permessions from '../../../permissions'

class MonitoraggioHabitatFormComponent extends Component {

    constructor(props) {
        super(props);

        this.state = {
            submitting: false,
            error: false,
        };
        this.onSubmit = this.onSubmit.bind(this);
	this.elencoMetadati = this.elencoMetadati.bind(this)
	this.onSpeciesSelect = this.onSpeciesSelect.bind(this)
    }

    elencoMetadati(habitat) {
	    var elenco = {}
	    for (var k=0; k<habitat.metadati.length; k++) {
		    elenco[habitat.metadati[k].metadato.id] = habitat.metadati[k].valore
	    }
	    return elenco
    }

    onSpeciesSelect(species) {
	    var x = this.props.client.query(
		    {query:metadatiHabitatQuery,
			variables:{id:species.id}}).then((result) => {
				var md = []
				for (var k=0; k<result.data.metadatiHabitatSpecie.length; k++) {
					var meta = {}
					meta.metadato = result.data.metadatiHabitatSpecie[k]
					meta.valore = ''
					md.push(meta)
					
				}
				var xx = {}
				xx.metadati=md
				this.setState({monitoraggioTemp:xx})
			}
			)
    }

    onSubmit(values) {

        const {client, submitMutation, data} = this.props;

        this.setState({submitting: true});

		var meta = []
	    var elenco = (data.monitoraggioHabitat?data.monitoraggioHabitat.metadati : this.state.monitoraggioTemp.metadati)
	for (var k=0; k<elenco.length; k++) {
		var md = {}
		md.valore = values[elenco[k].metadato.id]
		md.metadato = {}
		md.metadato.id = elenco[k].metadato.id
		meta.push(md)
		delete values[elenco[k].metadato.id]
	}

        let variables = {
            monitoraggio: {
                ...values,
		metadati: meta,
                specie: values.specie.id ? { id: values.specie.id, }: null,
                sitoNatura2000: values.sitoNatura2000 ? { id: values.sitoNatura2000[0].id } : null,
                tipologiaMonitoraggio: values.tipologiaMonitoraggio ? {id: values.tipologiaMonitoraggio}: null,
            }
        };

        delete variables.monitoraggio.__typename;

        if(data && data.id) {
            variables.monitoraggio.id = data.id;
        }

        client.mutate({
            mutation: submitMutation,
            variables: variables,
        }).then(res => {
	    this.props.data.refetch()
		this.setState({
                submitting: false,
            })
		if (!variables.monitoraggio.id) window.location.href='/LifeEremitaWeb/habitats/'+res.data.updateMonitoraggioHabitat.id+'/edit'
            /*if(this.props.onSubmitComplete) {
                this.props.onSubmitComplete();
            } else {
                this.props.history.goBack();
            }*/
        }).catch(err => {
            console.log(err);
            this.setState({
                submitting: false,
                error: true,
            });
        });
    }

    render() {
        const {data, readOnly, utenteSessione} = this.props;

        if(data && data.loading) {
            return(<Loading/>);
        }

        return (
            <Form
                defaultValues={data.monitoraggioHabitat ? {
                    ...data.monitoraggioHabitat,
		    ...this.elencoMetadati(data.monitoraggioHabitat),
                    specie: data.monitoraggioHabitat.specie ? findById(data.specieProgettos, data.monitoraggioHabitat.specie.id): null,
                    sitoNatura2000: data.monitoraggioHabitat.sitoNatura2000 ? [data.monitoraggioHabitat.sitoNatura2000]: null,
                    tipologiaMonitoraggio: data.monitoraggioHabitat.tipologiaMonitoraggio ? data.monitoraggioHabitat.tipologiaMonitoraggio.id: null,
                } : null}
                onSubmit={this.onSubmit}>
                {(formApi) => <form onSubmit={formApi.submitForm}>
                    <div className="row">
                        <div className="col">
                            <div className="form-group">
                                <label htmlFor="specie">Specie</label>
                                <SpeciesChooser onChange={this.onSpeciesSelect} nascondiPulsanteCambio={data.monitoraggioHabitat && data.monitoraggioHabitat.id} field="specie" id="specie" />
                            </div>
                        </div>
                    </div>
                    {!formApi.values.specie && <div className="row">
                        <div className="col">
                            <h5>Informazioni Generali</h5>
                            <div className="text-muted">Seleziona una specie per proseguire</div>
                        </div>
                    </div>}
                    {formApi.values.specie && <div>
                        <div className="row">
                            <div className="col">
                                <h5>Informazioni Generali</h5>
                            </div>
                        </div>
                        <div className="row">
                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="checkbox-input-authorize" className="mr-2">Validato</label>
                                    <Checkbox
                                        field="validato"
                                        id="checkbox-input-authorize"
                                        disabled={utenteSessione.loading ||
                                        utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permessions.validateMonitHabitat).length==0
                                        }
                                    />
                                </div>
                            </div>
                        </div>
                        <div className="row">
                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="idScheda">ID Scheda</label>
                                    <Text
                                        readOnly={readOnly}
                                        field="idScheda"
                                        id="idScheda"
                                        type="text"
                                        className="form-control" />
                                </div>
                            </div>
                        </div>
                        <div className="row">
                            <div className="col-md-8">
                                <div className="form-group">
                                    <label htmlFor="sitoNatura2000">Sito Natura 2000</label>
                                    <Typeahead
                                        readOnly={readOnly}
                                        dataQuery={sitoNatura2000SmartFilterQuery}
                                        helpText={"Cerca un sito Natura 2000 per nome"}
                                        searchText={"Ricerca in corso..."}
                                        paginationText={"Mostra di più..."}
                                        emptyLabel={"Nessun sito trovato."}
                                        promptText={"Scrivi per cercare..."}
                                        labelKey={"nome"}
                                        filterKey={"testo"}
                                        resultKey={"sitoNatura2000SmartFilter"}
                                        field="sitoNatura2000"
                                        id="sitoNatura2000"
                                        className="form-control"
                                        placeholder={""} />
                                </div>
                            </div>
                        </div>

                        <div className="row">
                            <div className="col-md-8">
                                <div className="form-group">
                                    <label htmlFor="rilevatori">Rilevatore/i</label>
                                    <Text field="rilevatori"
                                          readOnly={readOnly}
                                          id="rilevatori"
                                          type="text"
                                          className="form-control" />
                                </div>
                            </div>
                        </div>

                        <div className="row">
                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="inizioRilievo">Data e Ora Inizio Rilievo</label>
                                    <DateTime readOnly={readOnly} id="inizioRilievo" field="inizioRilievo" />
                                </div>
                            </div>
                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="fineRilievo">Data e Ora Fine Rilievo</label>
                                    <DateTime readOnly={readOnly} id="fineRilievo" field="fineRilievo" />
                                </div>
                            </div>
                        </div>

                        <div className="row">
                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="inizioRilievo">Provincia</label>
                                    <Text
                                        readOnly={readOnly}
                                        id="provincia"
                                        field="provincia"
                                        type="text"
                                        className="form-control"
                                    />
                                </div>
                            </div>
                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="fineRilievo">Comune</label>
                                    <Text
                                        readOnly={readOnly}
                                        id="comune"
                                        field="comune"
                                        type="text"
                                        className="form-control"
                                    />
                                </div>
                            </div>
                        </div>

                        <div className="row">
                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="inizioRilievo">Località</label>
                                    <Text
                                        readOnly={readOnly}
                                        id="localita"
                                        field="localita"
                                        type="text"
                                        className="form-control"
                                    />
                                </div>
                            </div>
                        </div>

                        <div className="row">

                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="transetto">Transetto Rilievo</label>
                                    <Text readOnly={readOnly} id="transetto"
                                          field="transetto"
                                          type="text"
                                          className="form-control" />
                                </div>
                            </div>
                        </div>

                        <div className="row">
                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="tipologiaMonitoraggio">Tipologia Monitoraggio</label>
                                    <TipologiaMonitoraggioSelect
                                        readOnly={readOnly}
                                        id="tipologiaMonitoraggio"
                                        field="tipologiaMonitoraggio"
                                        className="form-control"/>
                                </div>
                            </div>
                        </div>

			<div className="row">
                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="x">Coordinata X</label>
                                    <Text
                                        readOnly={readOnly}
                                        id="x"
			    		type="text"
                                        field="coordinataX"
                                        className="form-control"/>
                                </div>
                            </div>
                        </div>

			<div className="row">
                            <div className="col-md-6">
                                <div className="form-group">
                                    <label htmlFor="y">Coordinata Y</label>
                                    <Text
                                        readOnly={readOnly}
                                        id="y"
			    		type="text"
                                        field="coordinataY"
                                        className="form-control"/>
                                </div>
                            </div>
                        </div>

			<div className="row">
                            <div className="col">
                                <div className="form-group">
                                    <label htmlFor="note">Note</label>
                                    <TextArea rows="3" field="note" id="note" className="form-control" />
                                </div>
                            </div>
                        </div>

                        {data && <div>
                            <div className="row">
                                <div className="col">
                                    <h5>Altre Informazioni</h5>
                                </div>
                            </div>
                        </div>}

                        

                        {(data.monitoraggioHabitat || this.state.monitoraggioTemp) && <MonitoraggioHabitatMetadati data={data} monitoraggioTemp={this.state.monitoraggioTemp}/>}

                        <div className="row">
                            <div className="col">
                                <h5>Allegati al Monitoraggio</h5>
                            </div>

                        </div>

                        {data.monitoraggioHabitat && <MonitoraggioHabitatDocumenti data={data}/>}

                        {this.state.submitting && <div className="row">
                            <div className="col">
                                <div className="text-info text-center">Caricamento in corso...</div>
                            </div>
                        </div>}

                        {this.state.error && <div className="row">
                            <div className="col">
                                <div className="text-info text-center">Errore durante il salvataggio della scheda</div>
                            </div>
                        </div>}

                        <div className="row">
                            <div className="col">
                                <button disabled={this.state.submitting} type="submit" className="btn btn-primary">
                                    {data && data.monitoraggioHabitat && data.monitoraggioHabitat.id ? "SALVA SCHEDA" : "CREA NUOVA SCHEDA"}
                                </button>
                            </div>
                        </div>
                    </div>}
                </form>}
            </Form>);
    }
}

const MonitoraggioHabitatForm = withRouter(withApollo(MonitoraggioHabitatFormComponent));

MonitoraggioHabitatForm.defaultProps = {};

MonitoraggioHabitatForm.propTypes = {
    data: PropTypes.object,
    submitMutation: PropTypes.object.isRequired,
    errorMessage: PropTypes.string.isRequired,
    onSubmitComplete: PropTypes.func,
};

export default MonitoraggioHabitatForm;
